import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.promotionDistributionId) {
    newObjValue = {...newObjValue, M_PromotionDistribution_ID: {
      id: body.promotionDistributionId,
      tableName: 'M_PromotionDistribution'
    }}
  }
  if(body.targetDistributionId) {
    newObjValue = {...newObjValue, M_TargetDistribution_ID: {
      id: body.targetDistributionId,
      tableName: 'M_PromotionDistribution'
    }}
  }
  if(body.rewardTypeId) {
    newObjValue = {...newObjValue, RewardType: {
      id: body.rewardTypeId
    }}
  }
  if(body.distributionSortingId) {
    newObjValue = {...newObjValue, DistributionSorting: {
      id: body.distributionSortingId
    }}
  }
  if(body.chargeId) {
    newObjValue = {...newObjValue, C_Charge_ID: {
      id: body.chargeId,
      tableName: 'C_Charge'
    }}
  }

  if(body.promotionId) {
    const res: any = await fetchHelper(event, 'models/m_promotionreward', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      seqNo: body.seqNo,
      amount: body.amount,
      qty: body.qty,
      isForAllDistribution: body.isForAllDistribution,
      isSameDistribution: body.isSameDistribution,
      M_Promotion_ID: {
        id: body.promotionId,
        tableName: 'M_Promotion'
      },
      ...newObjValue,
      tableName: 'm_promotionreward'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})